/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.animation;

import icyllis.modernui.animation.ViscousFluidInterpolator;
import icyllis.modernui.math.MathUtil;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface Interpolator {
    @Nonnull
    public static final Interpolator LINEAR = in -> in;
    @Nonnull
    public static final Interpolator ACCELERATE = in -> in * in;
    @Nonnull
    public static final Interpolator DECELERATE = in -> 1.0f - (1.0f - in) * (1.0f - in);
    @Nonnull
    public static final Interpolator ACCELERATE_DECELERATE = in -> MathUtil.cos((in + 1.0f) * (float)Math.PI) * 0.5f + 0.5f;
    @Nonnull
    public static final Interpolator SINE = in -> MathUtil.sin(1.5707964f * in);
    @Nonnull
    public static final Interpolator OVERSHOOT = in -> (in - 1.0f) * (in - 1.0f) * (3.0f * (in - 1.0f) + 2.0f) + 1.0f;
    @Nonnull
    public static final Interpolator VISCOUS_FLUID = new ViscousFluidInterpolator();

    public float getInterpolation(float var1);
}

